## [s]CALABLE [v]ECTOR [g]GRAPHICS

The goal of this class is to reduce the complexity of code to create and manipulate svg images/documents.
This class will be augmented according to my needs but you are strongly encouraged to participate yourself through pull request.

## Summary

⚠️ svg extends the <a href="xml.md">`xml`</a>class

## Properties:

|Properties|Type|Description|Initial value|
|---------|:----:|------|:------:|
|**.root**|Text|The DOM tree reference in memory of the document virtual structure|**Null**|
|**.autoClose**|Boolean|Indicates whether the XML tree should be automatically closed after a call to one of the functions: `.exportPicture()`, `.exportText()`, `.picture()`, `.getText()`, `.save()` or `.preview()`|**True\*** 🚨|
|**.file**|**4D**.File|The disk file of the last `.save()` or `.load()`call|**Null**|
|**.success**|Boolean|Indicates whether a function call was successfully executed|
|**.errors**|Collection|The list of errors encoutered, if so|[ ]|
|**.latest**|Text|The DOM reference of the last element created|**Null**|
|**.graphic**|Picture|The image generated by the last call to the `.picture()` function.|**Null**|
|**.xml**|Text|The SVG tree as text generated during the last call to the `.getText()` function.|**Null**|
|**.store**|Collection|The element references memorized (see below)|[ ]|

\* 🚨 If `.autoClose` is set to **False** (or if you don't call a function that automatically closes the structure), once you no longer need the structure, remember to call the function `.close()` in order to free up the memory.

> 📌 `Point` type is a collection of 2 reals `[ x , y ]`  
> 
> 📌 With the exception of functions that return a specific result (getter function), each call returns the original `cs.svg` object, and you can include one call after another.

> 📌 If a function is called, without passing the `applyTo` parameter, the target is the last created path. If the `applyTo` parameter is passed, it must be a DOM reference.  

> 📌 If creation or a setting function is called, without passing the `applyTo` parameter, before the creation of an object in the canvas, the target is canvas itself, otherwise the target is the last created object. If the `applyTo` parameter is passed, it can be: a DOM reference, an id, the name of a reference stored with the `.push()` function or a reserved name (`"root"`, `"latest"`, `"parent"`).    

> 📌 Remember that you can still add unmanaged attributes with the functions `.setAttribute()` or `.setAttributes()`     

> 📌 Remember that you can always use DOM XML commands to manipulate the SVG tree `.root`, object `.latest` or reference retrieved with the `.fetch()` function.

### Document & structure functions

|Function|Action|
|--------|------|
|.**load** ( source : `4D.File` \| `Text` \| `Blob` {; validate : `Boolean` {; schema : `Text` }} ) → `cs.svg` | Loads a SVG tree from a file or a variable (TEXT or BLOB)
|.**picture** ( { exportType : `Integer`} {; keepStructure : `Boolean` } ) → `Picture`  | Returns the picture described by the SVG structure & populates the `.graphic` property if success.
|.**content** ( { keepStructure : `Boolean` } ) → `Text`  | Returns the SVG tree as text & populates the `.xml` property if success.
|.**exportPicture** ( file : `4D.file` {; keepStructure : `Boolean`} ) → `cs.svg` | Saves the SVG tree as a picture file.
|.**exportText** ( file : `4D.file` {; keepStructure : `Boolean`} ) → `cs.svg` | Writes the content of the SVG tree into a disk file.
|.**newCanvas** ( { attributes : `Object` } ) → `cs.svg` | Close the current tree if any & create a new svg default structure.
|.**close** () → `cs.svg` | Frees the memory taken up by the SVG tree \*
|.**save** ( { keepStructure : `Boolean` } ) → `cs.svg` | Saves the content of the SVG tree into the initially loaded file or the last created file by calling `exportText()`
|.**group** ( { id : `Text` {; attachTo }} ) → `cs.svg` | Defines a `g` element who is a container element for grouping together related graphics elements.
|.**symbol** ( id : `Text` {; applyTo } ) → `cs.svg` | To define a symbol
|.**use** ( id : `Text` {; attachTo } ) → `cs.svg` | To place an occurence of a symbol
|.**clipPath** ( id : `Text` {; applyTo } ) → `cs.svg` | Define a clipPath and apply to the root element
|.**style** ( style : `Text` {; applyTo } ) → `cs.svg` | Creates an internal CSS style sheet if applied to the root
|.**styleSheet** ( file : `4D.File` ) → `cs.svg` | Attach a style sheet
|.**viewbox** ( left : `Real`; top : `Real` ; width : `Real` ; height : `Real` {; attachTo } ) → `cs.svg` | Sets the `viewBox` attribute of a SVG viewport.
|.**relative**() → `cs.svg` | Defines the following coordinates as relative
|.**absolute**() → `cs.svg` | Defines the following coordinates as absolute

\* After the execution,`.root`is null but `.graphic` & `.xml` are always available

### Basic elements

|Function|Action|
|--------|------|   
|.**rect** ( height : `Real` {; width : `Real` } {; attachTo} ) → `cs.svg` | Creates a rectangle<br>Rounded rectangles can be obtained using `.rx()` & `.ry()`
|.**circle** ( radius : `Real` {; cx : `Real` {; cy : `Real`}} {; attachTo } ) → `cs.svg` | Creates a circle based on a center point and a radius.
|.**ellipse** ( radiusX : `Real`; radiusY : `Real`; cx : `Real`; cy : `Real` {; attachTo } ) → `cs.svg` | Creates an ellipse based on a center point and two radii  
|.**line** ( x1 : `Real`; y1 : `Real`; x2 : `Real`; y2 : `Real` {; attachTo } ) → `cs.svg` | Creates a line segment that starts at one point (`x1`,`y1`) and ends at another (`x2`,`y2`) 
|.**polyline** ( points : `Text` \| `Collection` {; attachTo } ) → `cs.svg` | Creates a set of connected straight line segments. Typically, `polyline` elements define open shapes.
|.**polygon** ( points : `Text` \| `Collection` {; attachTo } ) → `cs.svg` | Creates a closed shape consisting of a set of connected straight line segments.
|.**text** ( text : `Text` {; attachTo } ) → `cs.svg` | Creates a graphics element consisting of text.
|.**textArea** ( text : `Text` {; attachTo } ) → `cs.svg` | Creates a `textArea` element that allows simplistic wrapping of a text content within a given region.\*
|.**image** ( picture : `Picture` \| `4D.File` {; attachTo } ) → `cs.svg` | Creates an image element.<br>Can refer to an image file or a picture type variable (embedded picture)

\* The `textArea` elements are well rendered by 4D widgets but may not be supported by some browsers.

### path

|Function|Action|
|--------|------|   
|.**path** ( data : `Text` {; attachTo } ) → `cs.svg` | Creates a `path` element.<br>The element definition can be given in text form, or the path can be constructed using the hight level functions below.
||
|**# High-level**\* |
|.**moveTo**\** ( point : `Point` {; applyTo } ) → `cs.svg` | Starts a new sub-path at the given `point` [x,y] coordinate
|.**lineTo** ( point : `Point` {; applyTo } ) → `cs.svg` | Draws a line from the current point to the given `point` [x,y] coordinate which becomes the new current point<br>A number of coordinates pairs may be specified to draw a polyline
|.**horizontalLineto** ( x : `Real` {; applyTo } ) → `cs.svg` | Draws an horizontal line from the current point (cpx, cpy) to (x, cpy)
|.**verticalLineto** ( y : `Real` {; applyTo } ) → `cs.svg` |  Draws a vertical line from the current point (cpx, cpy) to (cpx, y)
|.**arc** ( to : `Point`; radii  : `Integer` \| `[rx,ry]`; rotation : `Real`; flags : `[ large-arc-flag , sweep-flag ]` {; applyTo } ) → `cs.svg` |  Draws a section of an ellipse from the current point `to` [x, y]<br>The ellipse has two `radii` [ rx , ry ]. If only one radius is given, both radii will be equal<br>The x-axis of the ellipse is rotated by `rotation`<br>`flags` [large-arc-flag , sweep-flag] indicate how the arc is drawn (4 different arcs could be drawn.
|.**cubicBezierCurveto** ( to : `Point`; beginCtrlPoint :`Point`; endCtrlPoint :`Point` {; applyTo } ) → `cs.svg` |  Draws a cubic Bézier curve from the current point to [x,y] using `beginCtrlPoint` [x1,y1] as the control point at the beginning of the curve and `endCtrlPoint` [x2,y2] as the control point at the end of the curve.
|.**smoothCubicBezierCurveto** ( to : `Point`; endCtrlPoint :`Point` {; applyTo } ) → `cs.svg` |  Draws a cubic Bézier curve from the current point to [x,y] using `endCtrlPoint` as the control point at the end of the curve.<br>The first control point is assumed to be the reflection of the second control point on the previous command relative to the current point.
|.**quadraticBezierCurveto** ( to : `Point`; controlPoint :`Point` {; applyTo } ) → `cs.svg` |  Draws a quadratic Bézier curve from the current point to [x,y] using `controlPoint` [x1,y1] as the control point.
|.**smoothQuadraticBezierCurveto** ( to : `Point` {; applyTo } ) → `cs.svg` |  Draws a quadratic Bézier curve from the current point to [x,y].<br>The control point is assumed to be the reflection of the control point on the previous command relative to the current point.
|.**closePath** ( ) → `cs.svg` | Close a path element
|.**d** ( points : `Text` {; applyTo } ) → `cs.svg` | Sets the "d" property of a path element
||
|# **Low-level**|
|.**M** / **m** ( points : `Text` \| `Collection` {; applyTo } ) → `cs.svg` | Absolute/Relative moveTo
|.**L**\** / **l**\** ( points : `Text` \| `Collection` {; applyTo } ) → `cs.svg` | Absolute/Relative lineTo
|.**H** / **h** ( x : `Real` {; applyTo } ) → `cs.svg` | Absolute/Relative horizontal lineTo
|.**V** / **v** ( y : `Real` {; applyTo } ) → `cs.svg` | Absolute/Relative vertical lineTo
|.**A** / **a** ( rx : `Real`; ry : `Real`; rotation : `Real`; largeArcFlag : `Integer`; sweepFlag : `Integer`; x : `Real`; y : `Real` {; applyTo } ) → `cs.svg` | Absolute/Relative  elliptical arc
|.**C** / **c** ( x1 : `Real`; y1 : `Real`; x2 : `Real`; y2 : `Real`; x : `Real`; y : `Real` {; applyTo } ) → `cs.svg` | Absolute/Relative  cubic Bézier curvTo
|.**S** / **s** ( x2 : `Real`; y2 : `Real`; x : `Real`; y : `Real` {; applyTo } ) → `cs.svg` | Absolute/Relative  shorthand/smooth cubic Bézier curvTo
|.**Q** / **q** ( x1 : `Real`; y1 : `Real`; x : `Real`; y : `Real` {; applyTo } ) → `cs.svg` | Absolute/Relative  quadratic Bézier curvTo
|.**T** / **t** ( x : `Real`; y : `Real` {; applyTo } ) → `cs.svg` | Absolute/Relative  shorthand/smooth quadratic Bézier curvTo
|.**Z** ( ) → `cs.svg` | Close a path element

\* Theses functions use **absolute** or **relative** coordinates according to the `absolute` property. Default is **absolute**. 
> 📌 To switch to relative coordinates, call the .**relative**() function: All subsequent coordinates will be interpreted as relative. To return to absolute coordinates, call the .**absolute**() function.

\** These functions can also be applied to `polyline` and `poligon` elements.

### Setting functions

|Function|Action|
|--------|------|
|.**id** ( id : `Text` {; applyTo } ) → `cs.svg` | Sets the ‘ID’ property of the SVG object(standard XML attribute)<br>If this attribute already exists, its value is replaced by the value passed in the parameter.
|.**x** ( x : `Real` {; applyTo } ) → `cs.svg` | Sets the x
|.**y** ( y : `Real` {; applyTo } ) → `cs.svg` | Sets the y
|.**width** ( width : `Real` {; applyTo } ) → `cs.svg` | Sets the width
|.**height** ( height : `Real` {; applyTo } ) → `cs.svg` | Sets the height
|.**translate** (tx : `Real` {; ty : `Real`} {; applyTo } ) →` cs.svg` | Specifies a translation by `tx` and `ty`. If the `ty` value is not provided, it is assumed to be zero
|.**scale** ( sx : `Real` {; sy : `Real` } {; applyTo } ) → `cs.svg` | Specifies a scaling operation by `sx` and `sy`. If the value `sy` is not provided, it is assumed to be equal to `sx`
|.**rotate** ( angle : `Integer` {; cx : `Real` ; cy : `Real`} {; applyTo } ) → `cs.svg` | Specifies a rotation of the `angle` value in degrees of a given point ;<br> • If the optional parameters `cx` and `cy` are not supplied, the rotation is performed with respect to the origin of the current user coordinate system.<br> • If the optional parameters `cx` and `cy` are supplied, the rotation is performed with respect to the point (`cx`,`cy`).
|.**fillColor** ( color : `Text` {; applyTo } ) → `cs.svg` | Sets the fill color
|.**fillOpacity** ( opacity : `Real` {; applyTo } ) → `cs.svg` | Sets the fill opacity
|.**strokeColor** ( color : `Text` {; applyTo } ) → `cs.svg` | Sets the stroke color
|.**strokeWidth** ( width : `Real` {; applyTo } ) → `cs.svg` | Sets the stroke width
|.**strokeOpacity** ( opacity : `Real` {; applyTo } ) → `cs.svg` | Sets the stroke opacity
|.**dasharray** ( dash : Real;  ...  : Integer)  → `cs.svg` | Defines the pattern of dashes and blanks used for the object's outline border<br>The integer value of the dash parameter indicates the length of the first dash of the dotted pattern. If the value parameters are omitted, the dotted line will consists of a series of dashes and gaps of the same length.<br>The decimal value of the dash parameter, if it is not null, indicates the distance into the pattern from which the dashes will start.
|.**fontFamily** ( fonts : `Text` {; applyTo } ) → `cs.svg` | Sets the font family
|.**fontSize** ( size : `Integer` {; applyTo } ) → `cs.svg` | Sets the font size
|.**fontStyle** ( style : `Integer` {; applyTo } ) → `cs.svg` | Sets teh font style
|.**alignment** ( alignment : `Integer` {; applyTo } ) → `cs.svg` | Sets the text alignment
|.**textRendering** ( rendering : `Text` {; applyTo } ) → `cs.svg` | Fix the text rendering
|.**visible** ( visible : `Boolean` {;applyTo } ) → `cs.svg` | Sets object visibility
|.**class** ( class : `Text` {; applyTo } ) → `cs.svg` | Sets the node class
|.**style** ( style : `Text` {; applyTo } ) → `cs.svg` | Assigns an embedded style
|.**preserveAspectRatio** ( value : `Text` {; applyTo} ) → `cs.svg` | Sets the attribute "preserveAspectRatio"
|.**r** ( r : `Real` {; applyTo } ) → `cs.svg` | Sets the radius of a circle
|.**rx** ( rx : `Real` {; applyTo } ) → `cs.svg` | Sets the rx of a rect or an ellipse
|.**ry** ( ry : `Real` {; applyTo } ) → `cs.svg` | Sets the ry of an ellipse
|.**cx** ( cx : `Real` {; applyTo } ) → `cs.svg` | Sets the cx of a circle or ellipse
|.**cy** ( cy : `Real` {; applyTo } ) → `cs.svg` | Sets the cy of a rect or an ellipse
|.**points** ( points : `Text` \| `Collection` {; applyTo } ) → `cs.svg` | Sets the "points" property of a polyline/polygon
|.**setAttribute** ( name : `Text`; value : `Variant` {; applyTo } ) → `cs.svg` | Sets one attribute
|.**setAttributes** ( attributes : `Text` \| `Collection` \| `Object`; value : `Variant` {; applyTo})  → `cs.svg` | Defines multiple attributes

### Shortcuts & utilities functions
 
|Function|Action|
|--------|------| 
|.**square** ( side : `Real` {; attachTo } ) → `cs.svg` | To draw a square
|.**regularPolygon** ( diameter : `Real` ; sides : `Integer`{; cx : `Real` ; cy : `Real` {; attachTo }} ) → `cs.svg` | Draws a regular polygon, with the given number of sides, fits into the circle set by `diameter`, `cx` & `cy`.
|.**fivePointStar** ( diameter : `Real` {; cx : `Real` ; cy : `Real` {; attachTo }} ) → `cs.svg` | Draws a five pointed star fits into the circle set by `diameter`, `cx` & `cy`.
|.**boundedEllipse** ( x : `Real` ; y : `Real` ; width : `Real` ; height : `Real`{; attachTo }} ) → `cs.svg` | Draws an ellipse fits into the rectangle set by `x`, `y`, `width` and `height`.
|.**color** ( color : `Text` {; applyTo } ) → `cs.svg` | Defines the color of both the line and the fill (`stroke` & `fill` attributes)
|.**opacity** ( opacity : `Real` {; applyTo } ) → `cs.svg` | Sets stroke and fill opacity
|.**fill** ( value `Text` \| `Boolean` \| `Object` {; applyTo } ) → `cs.svg` |  To define the painting of the inside of a shape (`fill` attributes)
|.**dropShadow** ({ deviation : `Integer` {; offsetX : `Integer` {; offsetY : `Integer` }}} ) → `cs.svg` |  Set a drop shadow for the current element.<br>• The optional `deviation` parameter sets the intensity of the shadow dispersion. Default value: 4.<br>• The optional `offsetX` and `offsetY` parameters specify, respectively, the horizontal and vertical offset of the shadow with respect to the object. Default value: 4.
|.**stroke** ( value `Text` \| `Boolean` \| `Real` \| `Object` {; applyTo } ) → `cs.svg` | To define the painting of the outline of a shape (`stroke` attribute)
|.**font** ( attributes : `Object` {; applyTo } ) → `cs.svg` | Sets the font attributes
|.**size** ({ width : `Real` {; height : `Real` {; unit : `Text`}}}) → `cs.svg` | Sets the dimensions
|.**position** ( x : `Real` {; y : `Real` }{; unit : `Text` } ) → `cs.svg` | Sets the position
|.**moveHorizontally** ( x : `Real` {; applyTo } ) → `cs.svg` | Moves horizontally
|.**moveVertically** ( y : `Real` {; applyTo } ) → `cs.svg` | Moves vertically
|.**radius** ( radius : `Integer` {; applyTo} ) → `cs.svg` | Fix the radius of a circle or a rounded rectangle
|.**plot** ( points : `Text` \| `Collection` {; applyTo} ) → `cs.svg` | Populate the "points" property of a polyline, polygon or the "data" proprety of a path
|.**show** ( { applyTo } ) → `cs.svg` | Make visible
|.**hide** ( { applyTo } ) → `cs.svg` | Make invisible
|.**setValue** ( value : `Text` {; applyTo }{; CDATA : `Boolean` } ) → `cs.svg` | Sets the element value
|.**setText** ( text : `Text` {; applyTo } )| To set the text value of a `text` or a `textArea`
|.**attachTo** ( parent : `Text` ) → `cs.svg` | Adds item to parent item
|.**clone** ( source : `Text` {; attachTo} ) → `cs.svg` |To create a copy of a svg object
|.**addClass** ( class : `Text` {; applyTo} ) → `cs.svg` | Add a value to the node class
|.**removeClass** ( class : `Text` {; applyTo} ) → `cs.svg` | Remove a value to the node class
|.**isOfClass** ( class : `Text` {; applyTo } ) → `isOfclass` : Boolean | Tests if the node belongs to a class
|.**layer** ( name : `Text` ) → `cs.svg` | Creates one or more group at the root of the SVG structure
|.**push** ( name : `Text` ) → `cs.svg` | Keeps the dom reference into the store associated with the given name
|.**fetch** ( name : `Text` ) → dom : `Text` | Retrieve a stored dom reference associated with the given name
|.**with** ( name : `Text` ) → `Boolean` | Defines an element for the next operations
|.**TextToPicture** ( text : Text {; fontAttributes : Object}) → `Picture` | Returns a picture of the given text.
|.**preview** ( { keepStructure : `Boolean` } ) | Display the SVG image & tree into the SVG Viewer if the component 4D SVG is available.

## 🔸 cs.svg.new()
The class constructor `cs.svg.new()` can be called without parameters to create a default svg structure with these attributes:
>`"viewport-fill"="none"`    
>`"fill"="none"`    
>`"stroke"="black"`    
>`"font-family"="'lucida grande','segoe UI',sans-serif"`    
>`"font-size"=12`    
>`"text-rendering"="geometricPrecision"`    
>`"shape-rendering"="crispEdges"`    
>`"preserveAspectRatio"="none"`

The class constructor also accepts an optional parameter, so you can create a svg structure by passing a 4D.File, a Blob variable or a Text variable.
>`cs.svg.new(4D.file)` Loads & parses the file content    
>`cs.svg.new(Blob)` Parses the blob variable content     
>`cs.svg.new(Text)` Parses the text variable content
